from torch.optim.optimizer import Optimizer, required
import copy

class AGD(Optimizer):


    def __init__(self, params, lr=required, theta = 0.9, weight_decay=0):
        defaults = dict(lr=lr, theta=theta, weight_decay=weight_decay)
        super(AGD, self).__init__(params, defaults)

    def __setstate__(self, state):
        super(AGD, self).__setstate__(state)

    def step(self, closure=None):
        """ Performs a single optimization step.
        Arguments:
            closure (callable, optional): A closure that reevaluates the model
                and returns the loss.
        """
        loss = None
        if closure is not None:
            loss = closure()

        for group in self.param_groups:
            weight_decay = group['weight_decay']
            theta = group['theta']
            lr = group['lr']

            for p in group['params']:
                if p.grad is None:
                    continue
                d_p = p.grad.data
                if weight_decay != 0:
                    d_p.add_(p.data, alpha=weight_decay)
                param_state = self.state[p]
                if 'momentum_buffer' not in param_state:
                    param_state['momentum_buffer'] = copy.deepcopy(p.data)
                buf = param_state['momentum_buffer']
                buf1 = copy.deepcopy(p.data)


                p.data.mul_(1.0 + theta)

                p.data.add_(buf, alpha=-theta)
                p.data.add_(d_p, alpha=-group['lr'])

                buf.copy_(buf1)




        return loss